*******************************************************
* SINEWAVE.SRC                                        *
*                                                     *
* This program generates a sine wave with a MC1408L8  *
* digital-to-analog converter attached to Port A of   *
* the 6821 PIA.  Each value output to the PIA is read *
* from a look-up table containing 1024 8-bit entries. *
* The entire table represents one period of a sine    *
* wave.  The frequency is controlled by the constant  *
* STEP which is used as the increment for the index   *
* into the table.                                     *
*******************************************************
PIA      EQU      $10001        ;PIA base address
CRA      EQU      1*2           ;Control Register A
STEP     EQU      13            ;index into the table

         ORG      $8000
SINEWAVE MOVEA.L  #TABLE,A1     ;A1 -> sine wave table
         MOVEA.L  #PIA,A0       ;A0 -> DDRA
         MOVE.B   #$FF,(A0)     ;Port A = output
         MOVE.B   #$04,CRA(A0)  ;A0 -> Port A
         CLR.W    D1
LOOP     MOVE.B   0(A1,D1.W),D0 ;14 cycles +
         MOVE.B   D0,(A0)       ;8 cycles  +
         ADDI.W   #STEP,D1      ;8 cycles  +
         ANDI.W   #$3FF,D1      ;8 cycles  +
         BRA      LOOP          ;10 cycles = 48 cycles

*******************************************************
* Frequency calculation:                              *
*        F = 3686400 / 48 / (1024 / STEP)             *
*          = 975 Hz                                   *
*******************************************************
* The following sine wave table contains 1024 entries *
* of integers between 0 and 255.                      *
*******************************************************
TABLE    DC.B 127
         DC.B 128
         DC.B 129
         DC.B 129
         DC.B 130
* Turn listing off after first five entries
* LSTOUT-
 DC.B 131
 DC.B 132
 DC.B 132
 DC.B 133
 DC.B 134
 DC.B 135
 DC.B 136
 DC.B 136
 DC.B 137
 DC.B 138
 DC.B 139
 DC.B 139
 DC.B 140
 DC.B 141
 DC.B 142
 DC.B 143
 DC.B 143
 DC.B 144
 DC.B 145
 DC.B 146
 DC.B 146
 DC.B 147
 DC.B 148
 DC.B 149
 DC.B 150
 DC.B 150
 DC.B 151
 DC.B 152
 DC.B 153
 DC.B 153
 DC.B 154
 DC.B 155
 DC.B 156
 DC.B 156
 DC.B 157
 DC.B 158
 DC.B 159
 DC.B 159
 DC.B 160
 DC.B 161
 DC.B 162
 DC.B 163
 DC.B 163
 DC.B 164
 DC.B 165
 DC.B 166
 DC.B 166
 DC.B 167
 DC.B 168
 DC.B 168
 DC.B 169
 DC.B 170
 DC.B 171
 DC.B 171
 DC.B 172
 DC.B 173
 DC.B 174
 DC.B 174
 DC.B 175
 DC.B 176
 DC.B 177
 DC.B 177
 DC.B 178
 DC.B 179
 DC.B 179
 DC.B 180
 DC.B 181
 DC.B 182
 DC.B 182
 DC.B 183
 DC.B 184
 DC.B 184
 DC.B 185
 DC.B 186
 DC.B 186
 DC.B 187
 DC.B 188
 DC.B 188
 DC.B 189
 DC.B 190
 DC.B 191
 DC.B 191
 DC.B 192
 DC.B 193
 DC.B 193
 DC.B 194
 DC.B 195
 DC.B 195
 DC.B 196
 DC.B 197
 DC.B 197
 DC.B 198
 DC.B 198
 DC.B 199
 DC.B 200
 DC.B 200
 DC.B 201
 DC.B 202
 DC.B 202
 DC.B 203
 DC.B 204
 DC.B 204
 DC.B 205
 DC.B 205
 DC.B 206
 DC.B 207
 DC.B 207
 DC.B 208
 DC.B 208
 DC.B 209
 DC.B 210
 DC.B 210
 DC.B 211
 DC.B 211
 DC.B 212
 DC.B 213
 DC.B 213
 DC.B 214
 DC.B 214
 DC.B 215
 DC.B 215
 DC.B 216
 DC.B 217
 DC.B 217
 DC.B 218
 DC.B 218
 DC.B 219
 DC.B 219
 DC.B 220
 DC.B 220
 DC.B 221
 DC.B 221
 DC.B 222
 DC.B 223
 DC.B 223
 DC.B 224
 DC.B 224
 DC.B 225
 DC.B 225
 DC.B 226
 DC.B 226
 DC.B 227
 DC.B 227
 DC.B 228
 DC.B 228
 DC.B 228
 DC.B 229
 DC.B 229
 DC.B 230
 DC.B 230
 DC.B 231
 DC.B 231
 DC.B 232
 DC.B 232
 DC.B 233
 DC.B 233
 DC.B 233
 DC.B 234
 DC.B 234
 DC.B 235
 DC.B 235
 DC.B 236
 DC.B 236
 DC.B 236
 DC.B 237
 DC.B 237
 DC.B 238
 DC.B 238
 DC.B 238
 DC.B 239
 DC.B 239
 DC.B 239
 DC.B 240
 DC.B 240
 DC.B 241
 DC.B 241
 DC.B 241
 DC.B 242
 DC.B 242
 DC.B 242
 DC.B 243
 DC.B 243
 DC.B 243
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 245
 DC.B 245
 DC.B 245
 DC.B 246
 DC.B 246
 DC.B 246
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 254
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 253
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 252
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 251
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 250
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 249
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 248
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 247
 DC.B 246
 DC.B 246
 DC.B 246
 DC.B 245
 DC.B 245
 DC.B 245
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 244
 DC.B 243
 DC.B 243
 DC.B 243
 DC.B 242
 DC.B 242
 DC.B 242
 DC.B 241
 DC.B 241
 DC.B 241
 DC.B 240
 DC.B 240
 DC.B 239
 DC.B 239
 DC.B 239
 DC.B 238
 DC.B 238
 DC.B 238
 DC.B 237
 DC.B 237
 DC.B 236
 DC.B 236
 DC.B 236
 DC.B 235
 DC.B 235
 DC.B 234
 DC.B 234
 DC.B 233
 DC.B 233
 DC.B 233
 DC.B 232
 DC.B 232
 DC.B 231
 DC.B 231
 DC.B 230
 DC.B 230
 DC.B 229
 DC.B 229
 DC.B 228
 DC.B 228
 DC.B 228
 DC.B 227
 DC.B 227
 DC.B 226
 DC.B 226
 DC.B 225
 DC.B 225
 DC.B 224
 DC.B 224
 DC.B 223
 DC.B 223
 DC.B 222
 DC.B 221
 DC.B 221
 DC.B 220
 DC.B 220
 DC.B 219
 DC.B 219
 DC.B 218
 DC.B 218
 DC.B 217
 DC.B 217
 DC.B 216
 DC.B 215
 DC.B 215
 DC.B 214
 DC.B 214
 DC.B 213
 DC.B 213
 DC.B 212
 DC.B 211
 DC.B 211
 DC.B 210
 DC.B 210
 DC.B 209
 DC.B 208
 DC.B 208
 DC.B 207
 DC.B 207
 DC.B 206
 DC.B 205
 DC.B 205
 DC.B 204
 DC.B 204
 DC.B 203
 DC.B 202
 DC.B 202
 DC.B 201
 DC.B 200
 DC.B 200
 DC.B 199
 DC.B 198
 DC.B 198
 DC.B 197
 DC.B 197
 DC.B 196
 DC.B 195
 DC.B 195
 DC.B 194
 DC.B 193
 DC.B 193
 DC.B 192
 DC.B 191
 DC.B 191
 DC.B 190
 DC.B 189
 DC.B 188
 DC.B 188
 DC.B 187
 DC.B 186
 DC.B 186
 DC.B 185
 DC.B 184
 DC.B 184
 DC.B 183
 DC.B 182
 DC.B 182
 DC.B 181
 DC.B 180
 DC.B 179
 DC.B 179
 DC.B 178
 DC.B 177
 DC.B 177
 DC.B 176
 DC.B 175
 DC.B 174
 DC.B 174
 DC.B 173
 DC.B 172
 DC.B 171
 DC.B 171
 DC.B 170
 DC.B 169
 DC.B 168
 DC.B 168
 DC.B 167
 DC.B 166
 DC.B 166
 DC.B 165
 DC.B 164
 DC.B 163
 DC.B 163
 DC.B 162
 DC.B 161
 DC.B 160
 DC.B 159
 DC.B 159
 DC.B 158
 DC.B 157
 DC.B 156
 DC.B 156
 DC.B 155
 DC.B 154
 DC.B 153
 DC.B 153
 DC.B 152
 DC.B 151
 DC.B 150
 DC.B 150
 DC.B 149
 DC.B 148
 DC.B 147
 DC.B 146
 DC.B 146
 DC.B 145
 DC.B 144
 DC.B 143
 DC.B 143
 DC.B 142
 DC.B 141
 DC.B 140
 DC.B 139
 DC.B 139
 DC.B 138
 DC.B 137
 DC.B 136
 DC.B 136
 DC.B 135
 DC.B 134
 DC.B 133
 DC.B 132
 DC.B 132
 DC.B 131
 DC.B 130
 DC.B 129
 DC.B 129
 DC.B 128
 DC.B 127
 DC.B 126
 DC.B 125
 DC.B 125
 DC.B 124
 DC.B 123
 DC.B 122
 DC.B 122
 DC.B 121
 DC.B 120
 DC.B 119
 DC.B 118
 DC.B 118
 DC.B 117
 DC.B 116
 DC.B 115
 DC.B 115
 DC.B 114
 DC.B 113
 DC.B 112
 DC.B 111
 DC.B 111
 DC.B 110
 DC.B 109
 DC.B 108
 DC.B 108
 DC.B 107
 DC.B 106
 DC.B 105
 DC.B 104
 DC.B 104
 DC.B 103
 DC.B 102
 DC.B 101
 DC.B 101
 DC.B 100
 DC.B  99
 DC.B  98
 DC.B  98
 DC.B  97
 DC.B  96
 DC.B  95
 DC.B  95
 DC.B  94
 DC.B  93
 DC.B  92
 DC.B  91
 DC.B  91
 DC.B  90
 DC.B  89
 DC.B  88
 DC.B  88
 DC.B  87
 DC.B  86
 DC.B  86
 DC.B  85
 DC.B  84
 DC.B  83
 DC.B  83
 DC.B  82
 DC.B  81
 DC.B  80
 DC.B  80
 DC.B  79
 DC.B  78
 DC.B  77
 DC.B  77
 DC.B  76
 DC.B  75
 DC.B  75
 DC.B  74
 DC.B  73
 DC.B  72
 DC.B  72
 DC.B  71
 DC.B  70
 DC.B  70
 DC.B  69
 DC.B  68
 DC.B  68
 DC.B  67
 DC.B  66
 DC.B  66
 DC.B  65
 DC.B  64
 DC.B  63
 DC.B  63
 DC.B  62
 DC.B  61
 DC.B  61
 DC.B  60
 DC.B  59
 DC.B  59
 DC.B  58
 DC.B  57
 DC.B  57
 DC.B  56
 DC.B  56
 DC.B  55
 DC.B  54
 DC.B  54
 DC.B  53
 DC.B  52
 DC.B  52
 DC.B  51
 DC.B  50
 DC.B  50
 DC.B  49
 DC.B  49
 DC.B  48
 DC.B  47
 DC.B  47
 DC.B  46
 DC.B  46
 DC.B  45
 DC.B  44
 DC.B  44
 DC.B  43
 DC.B  43
 DC.B  42
 DC.B  41
 DC.B  41
 DC.B  40
 DC.B  40
 DC.B  39
 DC.B  39
 DC.B  38
 DC.B  37
 DC.B  37
 DC.B  36
 DC.B  36
 DC.B  35
 DC.B  35
 DC.B  34
 DC.B  34
 DC.B  33
 DC.B  33
 DC.B  32
 DC.B  31
 DC.B  31
 DC.B  30
 DC.B  30
 DC.B  29
 DC.B  29
 DC.B  28
 DC.B  28
 DC.B  27
 DC.B  27
 DC.B  26
 DC.B  26
 DC.B  26
 DC.B  25
 DC.B  25
 DC.B  24
 DC.B  24
 DC.B  23
 DC.B  23
 DC.B  22
 DC.B  22
 DC.B  21
 DC.B  21
 DC.B  21
 DC.B  20
 DC.B  20
 DC.B  19
 DC.B  19
 DC.B  18
 DC.B  18
 DC.B  18
 DC.B  17
 DC.B  17
 DC.B  16
 DC.B  16
 DC.B  16
 DC.B  15
 DC.B  15
 DC.B  15
 DC.B  14
 DC.B  14
 DC.B  13
 DC.B  13
 DC.B  13
 DC.B  12
 DC.B  12
 DC.B  12
 DC.B  11
 DC.B  11
 DC.B  11
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B   9
 DC.B   9
 DC.B   9
 DC.B   8
 DC.B   8
 DC.B   8
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   0
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   1
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   2
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   3
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   4
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   5
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   6
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   7
 DC.B   8
 DC.B   8
 DC.B   8
 DC.B   9
 DC.B   9
 DC.B   9
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  10
 DC.B  11
 DC.B  11
 DC.B  11
 DC.B  12
 DC.B  12
 DC.B  12
 DC.B  13
 DC.B  13
 DC.B  13
 DC.B  14
 DC.B  14
 DC.B  15
 DC.B  15
 DC.B  15
 DC.B  16
 DC.B  16
 DC.B  16
 DC.B  17
 DC.B  17
 DC.B  18
 DC.B  18
 DC.B  18
 DC.B  19
 DC.B  19
 DC.B  20
 DC.B  20
 DC.B  21
 DC.B  21
 DC.B  21
 DC.B  22
 DC.B  22
 DC.B  23
 DC.B  23
 DC.B  24
 DC.B  24
 DC.B  25
 DC.B  25
 DC.B  26
 DC.B  26
 DC.B  26
 DC.B  27
 DC.B  27
 DC.B  28
 DC.B  28
 DC.B  29
 DC.B  29
 DC.B  30
 DC.B  30
 DC.B  31
 DC.B  31
 DC.B  32
 DC.B  33
 DC.B  33
 DC.B  34
 DC.B  34
 DC.B  35
 DC.B  35
 DC.B  36
 DC.B  36
 DC.B  37
 DC.B  37
 DC.B  38
 DC.B  39
 DC.B  39
 DC.B  40
 DC.B  40
 DC.B  41
 DC.B  41
 DC.B  42
 DC.B  43
 DC.B  43
 DC.B  44
 DC.B  44
 DC.B  45
 DC.B  46
 DC.B  46
 DC.B  47
 DC.B  47
 DC.B  48
 DC.B  49
 DC.B  49
 DC.B  50
 DC.B  50
 DC.B  51
 DC.B  52
 DC.B  52
 DC.B  53
 DC.B  54
 DC.B  54
 DC.B  55
 DC.B  56
 DC.B  56
 DC.B  57
 DC.B  57
 DC.B  58
 DC.B  59
 DC.B  59
 DC.B  60
 DC.B  61
 DC.B  61
 DC.B  62
 DC.B  63
 DC.B  63
 DC.B  64
 DC.B  65
 DC.B  66
 DC.B  66
 DC.B  67
 DC.B  68
 DC.B  68
 DC.B  69
 DC.B  70
 DC.B  70
 DC.B  71
 DC.B  72
 DC.B  72
 DC.B  73
 DC.B  74
 DC.B  75
 DC.B  75
 DC.B  76
 DC.B  77
 DC.B  77
 DC.B  78
 DC.B  79
 DC.B  80
 DC.B  80
 DC.B  81
 DC.B  82
 DC.B  83
 DC.B  83
 DC.B  84
 DC.B  85
 DC.B  86
 DC.B  86
 DC.B  87
 DC.B  88
 DC.B  88
 DC.B  89
 DC.B  90
 DC.B  91
 DC.B  91
 DC.B  92
 DC.B  93
 DC.B  94
 DC.B  95
 DC.B  95
 DC.B  96
 DC.B  97
 DC.B  98
 DC.B  98
 DC.B  99
 DC.B 100
 DC.B 101
 DC.B 101
 DC.B 102
 DC.B 103
 DC.B 104
 DC.B 104
 DC.B 105
 DC.B 106
 DC.B 107
 DC.B 108
 DC.B 108
 DC.B 109
 DC.B 110
 DC.B 111
 DC.B 111
 DC.B 112
 DC.B 113
 DC.B 114
 DC.B 115
 DC.B 115
 DC.B 116
 DC.B 117
 DC.B 118
 DC.B 118
 DC.B 119
 DC.B 120
 DC.B 121
 DC.B 122
 DC.B 122
*         LSTOUT+
*------------------------------------------------------
* Turn listing on for last five entries
         DC.B 123
         DC.B 124
         DC.B 125
         DC.B 125
         DC.B 126
         END  SINEWAVE
